/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.sensedia.interceptor.externaljar.dto.Body;
import com.sensedia.interceptor.externaljar.util.MultiStringMap;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class ApiMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Body body = new Body();
    protected MultiStringMap headers = new MultiStringMap();
    protected Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    protected X509Certificate[] certs;

    public Body getBody() {
        return this.body;
    }

    public MultiStringMap getHeaders() {
        return this.headers;
    }

    public String getHeader(String key) {
        String h = this.headers.get(key.toLowerCase());
        if (this.isBlank(h)) {
            return null;
        }
        return h;
    }

    public String getHeaderCaseSensitive(String key) {
        String h = this.headers.get(key);
        if (this.isBlank(h)) {
            return null;
        }
        return h;
    }

    public MultiStringMap getAllHeaders() {
        return this.headers;
    }

    public void setHeader(String key, String value) {
        this.headers.put(key.toLowerCase(), value);
    }

    public ApiMessage setHeaderCaseSensitive(String key, String value) {
        this.headers.remove(key.toLowerCase());
        this.headers.put(key, value);
        return this;
    }

    @JsonIgnore
    public List<String> getAllHeaderValues(String key) {
        List<String> r = this.headers.getAllValues(key.toLowerCase());
        if (r == null) {
            return new ArrayList<String>();
        }
        return r;
    }

    @JsonIgnore
    public List<String> getAllHeaderCaseSensitiveValues(String key) {
        List<String> r = this.headers.getAllValues(key);
        if (r == null) {
            return new ArrayList<String>();
        }
        return r;
    }

    public ApiMessage addHeader(String key, String value) {
        this.headers.addValue(key.toLowerCase(), value);
        return this;
    }

    @JsonIgnore
    public ApiMessage setBody(Body body) {
        this.body = body;
        return this;
    }

    @JsonIgnore
    public Set<String> getAllHeaderNames() {
        return this.headers.keySet();
    }

    public List<Cookie> getAllCookies() {
        return new ArrayList<Cookie>(this.cookies.values());
    }

    public void setCookie(String key, Cookie value) {
        this.cookies.put(key.toLowerCase(), value);
    }

    public void setCookie(Cookie value) {
        this.cookies.put(value.getName(), value);
    }

    public Cookie getCookie(String key) {
        return this.cookies.get(key.toLowerCase());
    }

    public Set<String> getAllCookieNames() {
        return this.cookies.keySet();
    }

    public String getCookieValue(String key) {
        Cookie c = this.cookies.get(key.toLowerCase());
        if (c == null) {
            return null;
        }
        try {
            return URLDecoder.decode(c.getValue().replace("+", "%2B"), "UTF-8").replace("%2B", "+");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract ApiMessage cloneWithoutBody();

    protected abstract ApiMessage clone();

    private boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public X509Certificate[] getCerts() {
        return this.certs;
    }

    public void setCerts(X509Certificate[] certs) {
        this.certs = certs;
    }
}

