/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.sensedia.interceptor.externaljar.dto.ApiMessage;
import com.sensedia.interceptor.externaljar.util.MultiStringMap;
import com.sensedia.interceptor.externaljar.util.QueryParamUtil;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ApiRequest
extends ApiMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String method;
    protected URI requestedUrl;
    protected String receivedFromAddress;
    protected long receivedTimeMillis;
    protected MultiStringMap queryParams = new MultiStringMap();

    public String getMethod() {
        return this.method;
    }

    public URI getRequestedUrl() {
        return this.requestedUrl;
    }

    public String getQueryString() {
        return QueryParamUtil.getQueryString(this.queryParams);
    }

    @JsonIgnore
    public Integer getTimeOfDay() {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(this.getReceivedTimeMillis());
        return c.get(11);
    }

    public String getQueryParam(String paramName) {
        return this.queryParams.get(paramName);
    }

    public String getReceivedFromAddress() {
        return this.receivedFromAddress;
    }

    public long getReceivedTimeMillis() {
        return this.receivedTimeMillis;
    }

    @Override
    public MultiStringMap getAllHeaders() {
        return this.headers;
    }

    public MultiStringMap getAllQueryParams() {
        return this.queryParams;
    }

    public Set<String> getAllQueryParamNames() {
        return this.queryParams.keySet();
    }

    @Override
    public ApiRequest cloneWithoutBody() {
        ApiRequest clone = new ApiRequest();
        clone.headers = MultiStringMap.clone(this.headers);
        clone.method = this.method;
        clone.queryParams = MultiStringMap.clone(this.queryParams);
        clone.receivedFromAddress = this.receivedFromAddress;
        clone.receivedTimeMillis = this.receivedTimeMillis;
        clone.requestedUrl = this.requestedUrl;
        clone.cookies = new HashMap(this.cookies);
        clone.certs = this.certs;
        return clone;
    }

    @Override
    public ApiRequest clone() {
        ApiRequest clone = this.cloneWithoutBody();
        clone.body = this.body;
        return clone;
    }

    public ApiRequest setQueryParam(String paramName, String value) {
        this.queryParams.put(paramName, value);
        return this;
    }

    public ApiRequest setReceivedFromAddress(String receivedFromAddress) {
        this.receivedFromAddress = receivedFromAddress;
        return this;
    }

    public ApiRequest setReceivedTimeMillis(long receivedTimeMillis) {
        this.receivedTimeMillis = receivedTimeMillis;
        return this;
    }

    public ApiRequest setRequestedUrl(URI requestedUrl) {
        this.requestedUrl = requestedUrl;
        return this;
    }

    public ApiRequest setMethod(String method) {
        this.method = method;
        return this;
    }

    public ApiRequest addQueryParam(String key, String value) {
        this.queryParams.addValue(key, value);
        return this;
    }

    @JsonIgnore
    public List<String> getAllQueryParamValues(String key) {
        List<String> r = this.queryParams.getAllValues(key);
        if (r == null) {
            return new ArrayList<String>();
        }
        return r;
    }

    @JsonIgnore
    public ApiRequest setAllQueryParam(MultiStringMap queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    @JsonIgnore
    public ApiRequest setAllHeaders(MultiStringMap headers) {
        this.headers = headers;
        return this;
    }
}

