/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.util;

import java.net.HttpCookie;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class Cookies {
    public SortedMap<String, HttpCookie> parseResponseCookieObjects(String setCookieHeader) {
        List<HttpCookie> cookies = HttpCookie.parse(setCookieHeader);
        TreeMap<String, HttpCookie> result = new TreeMap<String, HttpCookie>(String.CASE_INSENSITIVE_ORDER);
        if (cookies != null) {
            for (HttpCookie c : cookies) {
                result.put(c.getName(), c);
            }
        }
        return result;
    }

    public SortedMap<String, String> parseResponseCookieValues(String headerContents) {
        List<HttpCookie> cookies = HttpCookie.parse(headerContents);
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (cookies != null) {
            for (HttpCookie c : cookies) {
                result.put(c.getName(), c.getValue());
            }
        }
        return result;
    }

    public Map<String, String> parseRequestCookieValues(String headerContents) {
        String[] cookies;
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (headerContents == null || headerContents.trim().length() == 0) {
            return result;
        }
        for (String c : cookies = headerContents.split(";")) {
            String[] pieces = c.split("=");
            if (pieces.length <= 1) continue;
            String key = pieces[0].trim();
            String value = pieces[1].trim();
            result.put(key, value);
        }
        return result;
    }
}

