/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.dto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sensedia.interceptor.externaljar.dto.LocationEnum;
import com.sensedia.interceptor.externaljar.dto.LogCall;
import com.sensedia.interceptor.externaljar.dto.ObfuscationItem;
import com.sensedia.interceptor.externaljar.dto.TraceItem;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class Tracer {
    private Long t0 = System.currentTimeMillis();
    private List<TraceItem> traceItems = new ArrayList<TraceItem>();
    public List<ObfuscationItem> logObfuscationItems = new ArrayList<ObfuscationItem>();

    public void trace(String message, Object ... params) {
        this.traceItems.add(new TraceItem(this.t0, String.format(message, params), null));
    }

    public void trace(Exception e) {
        this.traceItems.add(new TraceItem(this.t0, e.getLocalizedMessage(), null));
    }

    public void trace(String message) {
        this.traceItems.add(new TraceItem(this.t0, message, null));
    }

    public void trace(String message, LogCall call) {
        if (this.logObfuscationItems.size() > 0) {
            for (ObfuscationItem obfuscationItem : this.logObfuscationItems) {
                String headerValue;
                if (obfuscationItem.location.equals(LocationEnum.BODY.name())) {
                    if (call.body.length() <= 0) continue;
                    String str = new String(call.body.getBytes(), StandardCharsets.UTF_8);
                    str = Tracer.applyRegex(obfuscationItem, str);
                    call.body = str.toString();
                    continue;
                }
                if (!obfuscationItem.location.equals(LocationEnum.HEADER.name()) || (headerValue = call.headers) == null) continue;
                obfuscationItem.regexToReplace = obfuscationItem.attr + ": \\w.*";
                obfuscationItem.replaceChar = obfuscationItem.attr + ": " + obfuscationItem.replaceChar;
                call.headers = Tracer.applyRegex(obfuscationItem, headerValue);
            }
        }
        this.traceItems.add(new TraceItem(this.t0, message, call));
    }

    public String getTrace() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(this.traceItems);
        }
        catch (JsonProcessingException e) {
            return e.getMessage();
        }
    }

    public static String applyRegex(ObfuscationItem obfuscationItem, String value) {
        return value.replaceAll(obfuscationItem.regexToReplace, obfuscationItem.replaceChar);
    }
}

