/*
 * Decompiled with CFR 0.152.
 */
package com.sensedia.interceptor.externaljar.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sensedia.interceptor.externaljar.rest.RESTException;
import com.sensedia.interceptor.externaljar.rest.RESTRequest;
import com.sensedia.interceptor.externaljar.rest.RESTResponse;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class RESTCaller {
    private String username;
    private String password;
    private String host;
    private Integer port;
    private String protocol;
    private String prefix;
    private String query;
    private Long timeoutMillis;
    private boolean throwExceptionIfError = false;

    public RESTCaller setDefaultHost(String protocol, String host, int port) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        return this;
    }

    public RESTCaller setDefaultHost(String protocol, String host, int port, String prefix) {
        return this.setDefaultHost(protocol, host, port, prefix, null);
    }

    public RESTCaller setDefaultHost(String protocol, String host, int port, String prefix, String query) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.setPrefix(prefix);
        this.query = query;
        return this;
    }

    public RESTCaller setDefaultHost(String fullHost) {
        try {
            URL u = new URL(fullHost);
            return this.setDefaultHost(u.getProtocol(), u.getHost(), u.getPort(), u.getPath(), u.getQuery());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public RESTCaller setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public RESTCaller setPrefix(String prefix) {
        this.prefix = prefix;
        if (this.prefix.startsWith("/")) {
            this.prefix = this.prefix.substring(1);
        }
        return this;
    }

    public RESTResponse call(String method, String path) {
        return this.call(new RESTRequest(method, path));
    }

    public RESTResponse call(String method, String path, String body) {
        return this.call(new RESTRequest(method, path).setTextBody(body));
    }

    public RESTResponse call(String method, String path, Object body) {
        return this.call(new RESTRequest(method, path).setJsonBody(body));
    }

    public RESTResponse call(String method, String path, String partName, File body) {
        return this.call(new RESTRequest(method, path).setFilePartBody(partName, body));
    }

    public RESTResponse call(RESTRequest request) throws RESTException {
        return this.call(request, this.throwExceptionIfError);
    }

    public RESTResponse call(RESTRequest request, boolean exceptionIfError) throws RESTException {
        BasicHttpParams params = new BasicHttpParams();
        if (this.timeoutMillis != null) {
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)10000);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)10000);
        }
        DefaultHttpClient httpclient = new DefaultHttpClient((HttpParams)params);
        HttpHost targetHost = new HttpHost(this.host, this.port.intValue(), this.protocol);
        try {
            BasicHttpContext localcontext = new BasicHttpContext();
            if (this.username != null && this.username.trim().length() > 0) {
                httpclient.getCredentialsProvider().setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(targetHost, (AuthScheme)basicAuth);
                localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
            }
            HttpGet req = null;
            String method = request.getMethod().toUpperCase();
            String uri = request.getUri();
            if (this.prefix != null && this.prefix.trim().length() > 0) {
                uri = this.prefix + uri;
            }
            if (!uri.startsWith("/")) {
                uri = "/" + uri;
            }
            if (this.query != null && !this.query.isEmpty()) {
                uri = uri + "?" + this.query;
            }
            if (method.equals("GET")) {
                req = new HttpGet(uri);
            } else if (method.equals("DELETE")) {
                req = new HttpDelete(uri);
            } else if (method.equals("POST")) {
                req = new HttpPost(uri);
                ((HttpPost)req).setEntity(this.makeEntity(request));
            } else if (method.equals("PUT")) {
                req = new HttpPut(uri);
                ((HttpPut)req).setEntity(this.makeEntity(request));
            }
            for (Map.Entry<String, String> h : request.getHeaders().entrySet()) {
                req.setHeader(h.getKey(), h.getValue());
            }
            HttpResponse response = httpclient.execute(targetHost, (HttpRequest)req, (HttpContext)localcontext);
            HttpEntity resEntity = response.getEntity();
            RESTResponse result = new RESTResponse();
            result.setStatus(response.getStatusLine().getStatusCode());
            for (Header h : response.getAllHeaders()) {
                result.getHeaders().put(h.getName(), h.getValue());
            }
            if (resEntity != null) {
                result.setResponseText(EntityUtils.toString((HttpEntity)resEntity, (Charset)StandardCharsets.UTF_8));
            }
            if (result.getStatus() >= 400 && exceptionIfError) {
                throw new RESTException(result);
            }
            RESTResponse rESTResponse = result;
            return rESTResponse;
        }
        catch (Exception t) {
            if (t instanceof RESTException) {
                throw (RESTException)t;
            }
            throw new RuntimeException(t);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    private HttpEntity makeEntity(RESTRequest request) throws Exception {
        Object payload = request.getBody();
        if (payload == null) {
            return null;
        }
        if (payload instanceof String) {
            StringEntity e = new StringEntity((String)payload, "utf-8");
            e.setContentType(this.addContentTypeIfMissing(request, "text/plain;charset=utf-8"));
            e.setContentEncoding("utf-8");
            return e;
        }
        if (payload instanceof byte[]) {
            ByteArrayEntity e = new ByteArrayEntity((byte[])payload);
            e.setContentType(this.addContentTypeIfMissing(request, "application/octet-stream"));
            return e;
        }
        if (payload instanceof FormBodyPart) {
            MultipartEntity e = new MultipartEntity();
            e.addPart((FormBodyPart)payload);
            return e;
        }
        String json = new ObjectMapper().writeValueAsString(payload);
        StringEntity reqEntity = new StringEntity(json, "utf-8");
        reqEntity.setContentType(this.addContentTypeIfMissing(request, "application/json;charset=utf-8"));
        reqEntity.setContentEncoding("utf-8");
        return reqEntity;
    }

    private String addContentTypeIfMissing(RESTRequest req, String contentType) {
        String existingType = req.getHeaders().get("Content-Type");
        if (existingType == null || existingType.trim().length() == 0) {
            req.getHeaders().put("Content-Type", contentType);
            return contentType;
        }
        return existingType;
    }

    public Long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public RESTCaller setTimeoutMillis(Long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public RESTResponse get(String url) {
        return this.call("get", url, null, (Object)null);
    }

    public RESTResponse get(String url, Map<String, Object> headers) {
        return this.call("get", url, headers, null);
    }

    public RESTResponse delete(String url) {
        return this.call("delete", url, null, (Object)null);
    }

    public RESTResponse delete(String url, Map<String, Object> headers) {
        return this.call("delete", url, headers, null);
    }

    public RESTResponse post(String url, Object body) {
        return this.call("post", url, null, body);
    }

    public RESTResponse post(String url, Map<String, Object> headers, Object body) {
        return this.call("post", url, headers, body);
    }

    public RESTResponse put(String url, Object body) {
        return this.call("put", url, null, body);
    }

    public RESTResponse put(String url, Map<String, Object> headers, Object body) {
        return this.call("put", url, headers, body);
    }

    public RESTResponse call(String method, String url, Map<String, ?> headers, Object body) {
        RESTRequest req = new RESTRequest(method, url);
        if (body != null) {
            this.setBody(req, body);
        }
        if (headers != null) {
            for (Map.Entry<String, ?> entry : headers.entrySet()) {
                if (entry.getValue() == null) continue;
                req.getHeaders().put(entry.getKey(), entry.getValue().toString());
            }
        }
        return this.call(req);
    }

    private void setBody(RESTRequest req, Object body) {
        if (body instanceof String) {
            req.setTextBody((String)body);
        } else {
            req.setJsonBody(body);
        }
    }

    public RESTCaller setThrowExceptionIfError(boolean throwExceptionIfError) {
        this.throwExceptionIfError = throwExceptionIfError;
        return this;
    }

    public boolean getThrowExceptionIfError() {
        return this.throwExceptionIfError;
    }
}

